unit IWDsnPaintHandlers;

{PUBDIST}

interface

uses
{$IFDEF VSNET}
   IWNetBaseControl, Windows,
{$ELSE}
{$IFDEF Linux}Types, {$ELSE}Windows, {$ENDIF}
{$IFDEF Linux}QButtons, {$ELSE}Buttons, {$ENDIF}
{$ENDIF}
{$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  {$IFDEF CLR}
  Types,
  {$ENDIF}
  Classes,
  IWFont, IWDsnPaint, IWColor;

type
  TIWPaintHandlerFile = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;
  
  TIWPaintHandlerFile32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;
  
  TIWPaintHandlerRadioButton = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRadioButton32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRadioButtonWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRadioGroup = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRadioGroup32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRectangle = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRectangle32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  {TIWPaintHandlerMenu = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;}

  TIWPaintHandlerLabel = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerLabel32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerLabelWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerButton = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerButton32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerButtonWAP = class(TIWPAintHandlerDsn)
  public
    procedure Paint; overridE;
  end;

  TIWPaintHandlerEdit = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerEdit32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerEditWAP = class(TIWPAintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerCheckBox = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerCheckBox32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerCheckBoxWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerComboBox = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerComboBox32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerComboBoxWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerListBox = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerListBox32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerListBoxWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerMemo = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerMemo32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerLink = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerLink32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerLinkWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerText = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerText32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerImage = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerImage32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerImageWAP = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerHRule = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerList = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerList32 = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  {$IFNDEF VSNET}
  TIWPaintHandlerDBNavigator = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerCSNavigator = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;
  {$ENDIF}
  
  TIWPaintHandlerProgressBar = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRegion = class(TIWPainthandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerTabControl = class(TIWPainthandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerTabPage = class(TIWPainthandlerDsn)
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerRegion32 = class(TIWPainthandlerDsn)
  public
    procedure Paint; override;
  end;

implementation

{$IFNDEF OBFUSCATE}
{$R IWDB.res}
{$ENDIF}

uses
{$IFDEF VSNET}
  System.Drawing, System.Reflection,
{$ELSE}
{$IFDEF Linux}QControls, {$ELSE}Controls, {$ENDIF}
{$ENDIF}
  Math, SysUtils,
  SWSystem, IWBaseControl, IWFormDsn, IWGridCommon,
  IWBaseHTMLForm,
  IWCompLabel, IWCompButton, IWCompEdit, IWCompText, IWExtCtrls,
  IWCompRectangle, IWHTMLControls, IWCompProgressBar, IWGrids,
  IWCompCheckbox, IWCompListbox, IWCompMemo,
  IWCompRadioButton,
  IWCompLabel32, IWCompButton32, IWCompEdit32, IWHTMLControls32,
  IWCompText32, IWCompRectangle32, IWCompMemo32, IWGrids32,
  IWCompRadioButton32,
  IWExtCtrls32, IWCompCheckbox32, IWCompListbox32, IWBaseHTMLControl,

  {$IFNDEF VSNET}
  IWCompMenu, IWDBExtCtrlsWAP, IWDBStdCtrls, IWCSStdCtrls,
  {$ENDIF}
  IWCompLabelWAP, IWCompEditWAP, IWCompCheckBoxWAP, IWCompButtonWAP,
  IWExtCtrlsWAP, IWCompRadioButtonWAP, IWCompListBoxWAP, IWWAPControls,
  IWRegion, IWRegion32, IWContainerBorderOptions, IWCompTabControl;

{ TIWPaintHandlerRadioGroup }

procedure TIWPaintHandlerRadioGroup.Paint;
var
  i: Integer;
  LHeight: Integer;
  LWidth: Integer;
  LLeft: Integer;
  LRadioGroup: TIWRadioGroup;
  LText: string;
  LTop: Integer;
begin
  LRadioGroup := Control as TIWRadioGroup;
  if LRadioGroup.Items.Count = 0 then begin
    DrawOutline{$IFDEF VSNET}(clSilver){$ENDIF};
  end else begin
    SetTransparent;
    with ControlCanvas do begin
      SetCanvasFont(LRadioGroup.WebFont);
      LLeft := 0;
      LTop := 0;
      if LRadioGroup.Items.Count > 0 then begin
        LText := LRadioGroup.Items.Strings[0];
        LHeight := Max(TextHeight(LText), 12) + 2;
        LWidth := TextWidth(LText) + 18;
        for i := 0 to LRadioGroup.Items.Count - 1 do begin
          DrawResource(iif(LRadioGroup.ItemIndex = i, 'RadioButtonChecked', 'RadioButtonUnchecked')
            , LLeft, LTop);
          TextOut(LLeft + 14, LTop, LRadioGroup.Items.Strings[i]);
          if LRadioGroup.Layout = glVertical then begin
            LTop := LTop + LHeight;
          end else begin
            LLeft := LLeft + LWidth;
          end;
        end;
      end;
    end;
  end;
end;

{ TIWPaintHandlerRectangle }

procedure TIWPaintHandlerRectangle.Paint;
var
  LRect: TIWCustomRectangle;
  LTextRect: TRect;
begin
  LRect := Control as TIWCustomRectangle;
  with ControlCanvas, LRect do begin
    if (BorderOptions.Width > 0) and (toTColor(BorderOptions.Color) <> clNone) and
      (toTColor(BorderOptions.Color) <> clWebTransparent) then begin
      Brush.Style := bsSolid;
      Brush.Color := toTColor(BorderOptions.Color);
      FillRect(Rect(0, 0, Width, Height));

      if (toTColor(WebColor) <> clNone) and (toTColor(WebColor) <> clWebTransparent) then begin
        Brush.COlor := toTColor(WebColor);
      end else begin
        Brush.Color := clWhite;
      end;
      FillRect(Rect(BorderOptions.Width, BorderOptions.Width,
        Width - BorderOptions.Width, Height - BorderOptions.Width));
    end else begin
      if (toTColor(WebColor) = clNone) or (toTColor(WebColor) = clWebTransparent) then begin
        DrawOutline;
      end else begin
        if (toTColor(WebColor) <> clNone) and (toTColor(WebColor) <> clWebTransparent) then begin
          Brush.Color := toTColor(WebColor);
        end else begin
          Brush.Color := clWhite;
        end;

        Brush.Style := bsSolid;
        Pen.Color := toTColor(WebColor);
        FillRect(Rect(0, 0, Width, Height));
      end;
    end;
    SetCanvasFont(WebFont);
    LTextRect := Rect(BorderOptions.Width + 1, BorderOptions.Width + 1, TextWidth(Text), TextHeight(Text));
    case Alignment of
      taRightJustify: begin
          LTextRect.Left := Width - BorderOptions.Width - LTextRect.Right;
        end;
      taCenter: begin
          LTextRect.Left := (Width - BorderOptions.Width - LTextRect.Right) div 2;
        end;
    end;

    case VAlign of
      vaMiddle: LTextRect.Top := (Height - LTextRect.Bottom) div 2;
      vaBottom: LTextRect.Top := Height - BorderOptions.Width - LTextRect.Bottom;
      // vaBaseline: LTextRect.Top := LRect.Height - LTextRect.Bottom;
    end;
    TextOut(LTextRect.Left, LTextRect.Top, Text);
  end;
end;

{ TIWPaintHandlerMenu }
(*
procedure TIWPaintHandlerMenu.Paint;
var
  IDx: integer;
  AutoXY: integer;
  // iWidth, iHeight: integer;
  LMenuControl: TIWMenu;
begin
  AutoXY := 0;
  LMenuControl := FControl as TIWMenu;
  Draw3DBox;
//  ControlCanvas.Font.Assign(Font);
  with LMenuControl do begin
    Canvas.Brush.Color := MenuStyle.Color;
    Canvas.Font.Color := MenuStyle.Font.Color;
    Canvas.Pen.Color := MenuStyle.HighlightColor;
    Canvas.Pen.Width := 2;
    Canvas.Font.Style := MenuStyle.Font.Style;
    Canvas.Font.Size := MenuStyle.Font.Size;
    Canvas.Font.Color := MenuStyle.Font.Color;
    Canvas.Font.Name := MenuStyle.Font.Name;
    Canvas.FillRect(Rect(0, 0, Width, Height));
  end;

  //	Draw the attached menu - top level only
  if Assigned(LMenuControl.AttachedMenu) and (LMenuControl.AttachedMenu.Items.Count > 0) then
  begin
    if LMenuControl.AutoSize <> mnaNone then
    begin
      if LMenuControl.Orientation = iwOHorizontal then
      begin
        if LMenuControl.ItemSpacing = itsEvenlySpaced then
          AutoXY := (LMenuControl.Width div LMenuControl.AttachedMenu.Items.Count)
        else
          AutoXY := (TIWAppForm(LMenuControl.Owner).Width div LMenuControl.AttachedMenu.Items.Count)
      end else
      begin
        if LMenuControl.ItemSpacing = itsEvenlySpaced then
          AutoXY := (LMenuControl.Height div LMenuControl.AttachedMenu.Items.Count)
        else
          AutoXY := (TIWAppForm(LMenuControl.Owner).Height div LMenuControl.AttachedMenu.Items.Count);
      end;
    end;

    for IDX := 0 to LMenuControl.AttachedMenu.Items.Count - 1 do
    begin
      if LMenuControl.Orientation = iwOHorizontal then
      begin
        if LMenuControl.AutoSize <> mnaNone then
        begin
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.Color;
          LMenuControl.Canvas.TextOut(LMenuControl.TextOffset + (AutoXY * IDx) + 1,
            (LMenuControl.MenuStyle.Height - LMenuControl.Canvas.TextHeight(FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption))) shr 1,
            FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption));
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.HighlightColor;
          {$IFDEF Linux}
          LMenuControl.Canvas.Rectangle(Rect(LMenuControl.TextOffset + (AutoXY * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ELSE}
          LMenuControl.Canvas.FrameRect(Rect(LMenuControl.TextOffset + (AutoXY * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ENDIF}
        end else
        begin
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.Color;
          LMenuControl.Canvas.TextOut(LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * IDx) + 1,
            (LMenuControl.MenuStyle.Height - LMenuControl.Canvas.TextHeight(FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption))) shr 1,
            FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption));
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.HighlightColor;
          {$IFDEF Linux}
          LMenuControl.Canvas.Rectangle(Rect(LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ELSE}
          LMenuControl.Canvas.FrameRect(Rect(LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ENDIF}
        end;
      end else
      begin
        if LMenuControl.AutoSize <> mnaNone then
        begin
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.Color;
          LMenuControl.Canvas.TextOut(1, LMenuControl.TextOffset + (AutoXY * IDx) + (LMenuControl.Canvas.TextHeight(FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption)) shr 1),
            FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption));
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.HighlightColor;
          {$IFDEF Linux}
          LMenuControl.Canvas.Rectangle(Rect(2, LMenuControl.TextOffset + (AutoXY * IDx) + 2,
            LMenuControl.MenuStyle.Width - 2, LMenuControl.TextOffset + (LMenuControl.MenuStyle.Height * (IDx + 1)) - 2));
          {$ELSE}
          LMenuControl.Canvas.FrameRect(Rect(2, LMenuControl.TextOffset + (AutoXY * IDx) + 2,
            LMenuControl.MenuStyle.Width - 2, LMenuControl.TextOffset + (LMenuControl.MenuStyle.Height * (IDx + 1)) - 2));
          {$ENDIF}
        end else
        begin
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.Color;
          LMenuControl.Canvas.TextOut(1, LMenuControl.TextOffset + (LMenuControl.MenuStyle.Height * IDx) +
            (LMenuControl.Canvas.TextHeight(FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption)) shr 1),
            FixCaption(LMenuControl.AttachedMenu.Items[IDX].Caption));
          LMenuControl.Canvas.Brush.Color := LMenuControl.MenuStyle.HighlightColor;
          {$IFDEF Linux}
          LMenuControl.Canvas.Rectangle(Rect(LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ELSE}
          LMenuControl.Canvas.FrameRect(Rect(LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * IDx) + 2, 2,
            LMenuControl.TextOffset + (LMenuControl.MenuStyle.Width * (IDx + 1)) - 2, LMenuControl.MenuStyle.Height - 2));
          {$ENDIF}
        end;
      end;
    end;
    //ControlCanvas.TextOut(4, (Height - ControlCanvas.TextHeight('No Menu')) shr 1, FAttachedMenu.Name);
  end else
    LMenuControl.Canvas.TextOut(4, (LMenuControl.Height - LMenuControl.Canvas.TextHeight('No Menu')) shr 1, 'No menu attached');
end;
*)
{ TIWPaintHandlerLabel }

procedure TIWPaintHandlerLabel.Paint;
var
  LWidth: Integer;
  LLabel: TIWCustomLabel;
  LLeft: Integer;
{$IFDEF VSNET}
  L: TIWColor;
{$ENDIF}
begin
  LLabel := Control as TIWCustomLabel;
  with LLabel, ControlCanvas do
  begin
{$IFNDEF Linux}
    TextFlags := 0;
{$ENDIF}
    if (toTColor(BGColor) <> clNone) and (toTColor(BGColor) <> clWebTransparent) then
    begin
      Brush.Color := ToTColor(BGColor);
      Brush.Style := bsSolid;
      {$IFDEF VSNET}
      FillRect(Rect(-1, -1, Width + 1, Height + 1));
      {$ELSE}
      FillRect(Rect(0, 0, Width, Height));
      {$ENDIF}
    end
    else
    begin
      {$IFDEF VSNET}
      if Parent is TIWBaseHTMLForm then begin
        L := TIWBaseHTMLForm(Parent).BGColor;
      end else begin
        if Parent is TIWCustomRegion then begin
          L := TIWCustomRegion(Parent).WebColor;
        end;
      end;
      if (toTColor(L) <> clNone) and (toTColor(L) <> clWebTransparent) then
      begin
        Brush.Color := ToTColor(L);
      end
      else begin
        Brush.Color := clWhite;
      end;
      Brush.Style := bsSolid;
      FillRect(Rect(-1, -1, Width + 1, Height + 1));
      {$ELSE}
      // Transparent. Do NOT set Brush.Color after this, it will reset this to bsSolid.
      Brush.Style := bsClear;
      {$ENDIF}
    end;

    SetCanvasFont(LLabel.WebFont);
    if LLabel.Align = alNone then
    begin
      if LLabel.AutoSize then
      begin
        LWidth := TextWidth(LLabel.Caption);
        if LLabel.Alignment = taLeftJustify then
        begin
          LWidth := Trunc(LWidth * 1.10); { <- it causes wrong size calc at design
                                            if taRightJustify or taLeftJustify. Ivan }
        end;
      end
      else
      begin
        LWidth := LLabel.Width;
      end;
    end
    else
    begin
      LWidth := LLabel.Width;
    end;
    LLeft := 0;
    case LLabel.Alignment of
      taLeftJustify: LLeft := 0;
      taCenter: LLeft := (LWidth div 2) - (TextWidth(LLabel.Caption) div 2);
      taRightJustify: LLeft := LWidth - TextWidth(LLabel.Caption);
    end;
    TextRect(Rect(LLeft, 0, LWidth, TextHeight(LLabel.Caption)), LLeft, 0, LLabel.Caption);
    if (LLabel.Align = alNone) and LLabel.AutoSize then
    begin
      LLabel.Width := LWidth;
      LLabel.Height := TextHeight(LLabel.Caption);
    end;
  end;
end;

procedure TIWPaintHandlerButton.Paint;
var
  LRect: TRect;
  LButton: TIWCustomButton;
begin
  LButton := Control as TIWCustomButton;
  with ControlCanvas do begin
    LRect := DrawButton(Rect(0, 0, LButton.Width - 1, LButton.Height - 1), 1);
    Brush.Style := bsSolid;
    if (toTColor(LButton.WebColor) <> clNone) and (toTColor(LButton.WebColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(LButton.WebColor);
    end else begin
      Brush.Color := clWhite;
    end;
    FillRect(LRect);
    SetCanvasFont(LButton.WebFont);
    TextRect(LRect, Max(0, (LRect.Right - LRect.Left - TextWidth(LButton.Caption)) div 2)
      , Max(0, (LRect.Bottom - LRect.Top - TextHeight(LButton.Caption)) div 2), LButton.Caption);
  end;
end;

{ TIWPaintHandlerEdit }

procedure TIWPaintHandlerEdit.Paint;
var
  LEdit: TIWCustomEdit;
  LLeft: Integer;
  LRect: TRect;
  S: string;
begin
  LEdit := Control as TIWCustomEdit;
  with ControlCanvas do
  begin
    S := LEdit.Text;

    SetCanvasFont(LEdit.WebFont);

    if (toTColor(LEdit.BGColor) <> clNone) and (toTColor(LEdit.BGColor) <> clWebTransparent) then
    begin
      Brush.Color := toTColor(LEdit.BGColor);
    end
    else
    begin
      Brush.Color := clWhite;
    end;

    Pen.Color := clBlack;
    Pen.Width := 1;
    Rectangle(Rect(0, 0, LEdit.Width, LEdit.Height));
    LRect := Rect(0, 0, LEdit.Width - 2, LEdit.Height - 2);
    Draw3DBox(LRect, 1, clSilver, [ssBottom, ssRight]);

    if (toTColor(LEdit.BGColor) <> clNone) and (toTColor(LEdit.BGColor) <> clWebTransparent) then
    begin
      Brush.Color := toTColor(LEdit.BGColor);
    end;

    LLeft := 2;
    case LEdit.Alignment of
      taLeftJustify: LLeft := 2;
      taCenter: LLeft := (LEdit.Width div 2) - (TextWidth(S) div 2) + 2;
      taRightJustify: LLeft := LEdit.Width - TextWidth(S) - 2;
    end;
    TextRect(Rect(LLeft, 2, Min(LEdit.Width - 2, LLeft + TextWidth(S)), LEdit.Height - 2), LLeft, 2, S);
  end;
end;

{ TIWPaintHandlerCheckBox }

procedure TIWPaintHandlerCheckBox.Paint;
var
  LCheckBox: TIWCustomCheckBox;
begin
  LCheckBox := Control as TIWCustomCheckBox;
  with ControlCanvas do begin
    Draw3DBox(Rect(1, 1, 14, 14), 1, clSilver, [ssBottom, ssRight]);
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Rectangle(3, 3, 13, 13);
    SetCanvasFont(LCheckBox.WebFont);
    Brush.Style := bsClear;
    TextRect(Rect(20, 2, LCheckBox.Width - 1, LCheckBox.Height - 2), 20, 2, LCheckBox.Caption);
    if LCheckBox.Checked then begin
      Pen.Color := clBlack;
      Brush.Color := clBlack;
      Brush.Style := bsSolid;
      Polygon([{$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7),
        {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 9),
               {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 11), {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 7),
               {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 5), {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 9)
        , {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7)]);
    end;
  end;
end;

{ TIWPaintHandlerComboBox }

procedure TIWPaintHandlerComboBox.Paint;
var
  LRect: TRect;
  LComboBox: TIWCustomComboBox;
begin
  LComboBox := Control as TIWCustomComboBox;
  with ControlCanvas, LComboBox do begin
    Draw3DBox;
    SetCanvasFont(LComboBox.WebFont);

    if (ToTColor(BGColor) = clNone) or (toTColor(BGColor) = clWebTransparent) then begin
      Brush.Color := clWhite;
    end else begin
      Brush.Color := ToTColor(BGColor);
    end;

    if (ItemIndex >= 0) and (ItemIndex < Items.Count) then begin
      if LComboBox.ItemsHaveValues then begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Values[Items.Names[ItemIndex]]);
      end
      else begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Strings[ItemIndex]);
      end;
    end else begin
      Rectangle(2, 2, Width - 18, Height - 2);
    end;
  //  ControlCanvas.MoveTo(Width - 16, Height -1);
  //  ControlCanvas.LineTo(Width - 16, Height -1);
    LRect := DrawButton(Rect(Width - 17, Height - 18, Width - 2, Height - 2));
    //TODO : Button not EXACTLY the same but will do for now. View under zoom 5:1 to see diff
    DrawArrow(LRect, adDown);
  end;
end;

{ TIWPaintHandlerListBox }

procedure TIWPaintHandlerListBox.Paint;
var
  Ln, YPos, Bt: Integer;
  LText: string;
  LListBox: TIWCustomListbox;
begin
  LListBox := Control as TIWCustomListbox;
  with ControlCanvas, LListBox do
  begin
    if (ToTColor(BGColor) = clNone) or (toTColor(BGColor) = clWebTransparent) then begin
      Brush.Color := clWhite;
    end else begin
      Brush.Color := ToTColor(BGColor);
    end;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, LListBox.Width, LListBox.Height));

    Ln := 0;
    YPos := 1;
    while (YPos < LListBox.Height - 2) and (Ln < LListBox.Items.Count) do
    begin
      SetCanvasFont(LListBox.WebFont);
      if ItemsHaveValues then
      begin
        LText := Items.Names[Ln];
      end
      else
      begin
        LText := Items.Strings[Ln];
      end;

      if Length(LText) < 1 then
      begin
        LText := ' ';
      end;

      Bt := YPos + TextHeight(LText);
      if Bt >= LListBox.Height - 2 then
      begin
        Bt := LListBox.Height - 2;
      end;

      if (not LListBox.MultiSelect and (LListBox.ItemIndex = Ln)) or (LListBox.MultiSelect and LListBox.Selected[ln]) then
      begin
        ControlCanvas.Font.Color := clWhite;
        ControlCanvas.Brush.Color := clBlack;
      end
      else
      begin
        // Font.Color := LListBox.Font.Color;
        if (ToTColor(BGColor) = clNone) or (toTColor(BGColor) = clWebTransparent) then begin
          Brush.Color := clWhite;
        end else begin
          Brush.Color := ToTColor(BGColor);
        end;
      end;
      { TODO : Fix black marker on line }
      TextRect(Rect(4, YPos + 2, LListBox.Width - 5, Bt), 4, YPos + 2, LText);
      // Font.Color := LListBox.Font.Color;
      Brush.Color := clNone;

      Inc(Ln);
      YPos := Bt;
    end;
    Draw3DBox;
  end;
end;

{ TIWPaintHandlerMemo }

procedure TIWPaintHandlerMemo.Paint;
var
  LMemo: TIWCustomMemo;
begin
  LMemo := Control as TIWCustomMemo;
  with ControlCanvas, LMemo do begin
    if (toTColor(BGColor) <> clNone) and (toTColor(BGColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(BGColor);
    end else begin
      Brush.Color := clWhite;
    end;
    Draw3DBox;
    Rectangle(Rect(2, 2, Width - 16, Height - 2));
    SetCanvasFont(LMemo.WebFont);
    DrawTextLines(Rect(3, 2, Width - 15, Height - 1), LMemo.Lines, true);
    if LMemo.VertScrollBar then begin
      DrawScrollbar(Rect(Width - 16, 1, Width - 1, Height - 1));
    end;
  end;
end;

{ TIWPaintHandlerLink }

procedure TIWPaintHandlerLink.Paint;
var
  LLink: TIWLinkBase;
{$IFDEF VSNET}
  L: TIWColor;
{$ENDIF}
begin
  LLink := Control as TIWLinkBase;
  with ControlCanvas do begin
    SetCanvasFont(LLink.WebFont);
    {$IFDEF VSNET}
    if LLink.Parent is TIWBaseHTMLForm then begin
      L := TIWBaseHTMLForm(LLink.Parent).BGColor;
    end else begin
      if LLink.Parent is TIWCustomRegion then begin
        L := TIWCustomRegion(LLink.Parent).WebColor;
      end;
    end;
    if (toTColor(L) <> clNone) and (toTColor(L) <> clWebTransparent) then
    begin
      Brush.Color := ToTColor(L);
    end
    else begin
      Brush.Color := clWhite;
    end;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, LLink.Width, LLink.Height));
    {$ELSE}
    Brush.Style := bsClear;
    {$ENDIF}
    if (toTColor(LLink.WebColor) <> clNone) and (toTColor(LLink.WebColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(LLink.WebColor);
    end;
    case LLink.Alignment of
      taLeftJustify: TextOut(0, 0, LLink.Caption);
      taRightJustify: TextOut(ClipRect.Right - TextWidth(LLink.Caption), 0, LLink.Caption);
      taCenter: TextOut((ClipRect.Right - ClipRect.Left - TextWidth(LLink.Caption)) div 2, 0, LLink.Caption);
    end;
  end;
end;

{ TIWPaintHandlerText }

procedure TIWPaintHandlerText.Paint;
var
  LText: TIWCustomText;
begin
  LText := Control as TIWCustomText;
  with ControlCanvas do
  begin
    if LText.Lines.Count = 0 then
    begin
      SetTransparent;
      DrawOutline{$IFDEF VSNET}(clSilver){$ENDIF};
      DrawResource(Control.ClassName, (Control.Width - 24) div 2, (Control.Height - 24) div 2);
    end
    else
    begin
      if (toTColor(LText.BGColor) <> clNone) and (toTColor(LText.BGColor) <> clWebTransparent) then
      begin
        Brush.Color := toTColor(LText.BGColor);
      end
      else
      begin
        Brush.Color := clWhite;
      end;
      Brush.Style := bsSolid;
      Pen.Color := toTColor(LText.BGColor);
      FillRect(Rect(0, 0, LText.Width, LText.Height));

      SetCanvasFont(LText.WebFont);
      DrawTextLines(Rect(1, 1, LText.Width - 2, LText.Height - 2), LText.Lines, true);
    end;
  end;
end;

{ TIWPaintHandlerImage }

procedure TIWPaintHandlerImage.Paint;
var
  LImage: TIWCustomImage;
  LX, LY: Integer;
begin
  LImage := Control as TIWCustomImage;
  LX := 0;
  LY := 0;
  with ControlCanvas, LImage do begin
    // FPicture is nil during initial create at design time for TIWImageFile (inherited Create)
    if (BorderOptions.Width > 0) and (toTColor(BorderOptions.Color) <> clNone)
      and (toTColor(BorderOptions.Color) <> clWebTransparent) then begin
      Brush.Color := toTColor(BorderOptions.Color);
      Brush.Style := bsSolid;
      Pen.Color := toTColor(BorderOptions.Color);
      Rectangle(LX, LY, Width, Height);
      Brush.Color := toTColor(WebColor);
      Brush.Style := bsSolid;
      Pen.Color := toTColor(WebColor);
      Rectangle(BorderOptions.Width, BorderOptions.Width,
        Width - BorderOptions.Width, Height - BorderOptions.Width);
      LX := LX + BorderOptions.Width;
      LY := LY + BorderOptions.Width;
    end;
    if LImage.Picture <> nil then begin
      if LImage.Picture.Graphic <> nil then begin
        if not LImage.RenderSize then begin
          Draw(LX, LY, LImage.Picture.Graphic);
        end else begin
          StretchDraw(Rect(0, 0, LImage.Width, LImage.Height), LImage.Picture.Graphic);
        end;
      end else begin
        DrawOutLine(LX, LY, Width - BorderOptions.Width, Height - BorderOptions.Width{$IFDEF VSNET}, clSilver{$ENDIF});
        DrawResource(ClassName, (Width - 24) div 2, (Height - 24) div 2);
      end;
    end;
  end;
end;

{ TIWPaintHandlerHRule }

procedure TIWPaintHandlerHRule.Paint;
begin
  with ControlCanvas do
  begin
    Brush.Color := clBlack;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, Control.Width, Control.Height));
  end;
end;

{ TIWPaintHandlerList }

procedure TIWPaintHandlerList.Paint;
var
  i, LHeight: integer;
  s: string;
  LList: TIWList;
begin
  LList := Control as TIWList;
  with ControlCanvas do
  begin
    SetTransparent;
    SetCanvasFont(LList.WebFont);
    if LList.Items.Count > 0 then
    begin
      LHeight := TextHeight(LList.Items.Strings[0]);
      for i := 0 to LList.Items.Count - 1 do
      begin
        s := LList.Items.Strings[i];
        if LList.Numbered then
        begin
          s := IntToStr(i + 1) + ' ' + s;
        end
        else
        begin
          //TODO: Change to a real bullet
          s := '* ' + s;
        end;
        TextOut(0, i * LHeight, s);
      end;
    end
    else
    begin
      DrawOutline;
      DrawResource(Control.ClassName, (Control.Width - 24) div 2, (Control.Height - 24) div 2);
    end;
  end;
end;

{ TIWPaintHandlerDBNavigator }
{$IFNDEF VSNET}
procedure TIWPaintHandlerDBNavigator.Paint;
const
  LCXOffset = 3;
  LCYOffset = 3;
var
  LLeft, LTop: Integer;
  LDeltaLeft, LDeltaTop: Integer;
  LNavigator: TIWDBNavigator;
{$IFDEF CLR}
  LInstance: HModule;
{$ENDIF}

  procedure DrawImage(AResourceName: string; var ALeft, ATop : integer; ADeltaLeft, ADeltaTop : integer);
  var
    LBitmap : TBitmap;
  begin
    {$IFDEF CLR}
    LBitmap := TBitmap.Create;
    {$ELSE}
    LBitmap := {$IFDEF Linux}QGraphics{$ELSE}Graphics{$ENDIF}.TBitmap.Create;
    {$ENDIF}
    try
      {$IFDEF CLR}
      LInstance := FindInstanceContainingResource(AResourceName, RT_BITMAP);
      LBitmap.LoadFromResourceName(LInstance, AResourceName);
      {$ELSE}
      LBitmap.LoadFromResourceName(HInstance, UpperCase(AResourceName));
      {$ENDIF}
      LBitmap.TransparentColor := LBitmap.Canvas.Pixels[0, 0];
      LBitmap.Transparent := true;
      DrawButton(Rect(ALeft, ATop, ALeft + LBitmap.Width + LCXOffset * 2, ATop + LBitmap.Height + LCYOffset * 2), 0);
      ControlCanvas.Draw(ALeft + LCXOffset, ATop + LCYOffset, LBitmap);
    finally
      FreeAndNil(LBitmap);
    end;

    Inc(ALeft, ADeltaLeft);
    Inc(ATop, ADeltaTop);
  end;

begin
  // Depending on number of buttons do the painting.
  LLeft := 0;
  LTop := 0;
  LDeltaLeft := 0;
  LDeltaTop := 0;

  LNavigator := Control as TIWDBNavigator;

  with LNavigator do
  begin
    case Orientation of
      orHorizontal  : begin
                        LDeltaLeft := ImageWidth + LCXOffset * 2;
                        LDeltaTop := 0;
                      end;
      orVertical    : begin
                        LDeltaLeft := 0;
                        LDeltaTop := ImageHeight + LCYOffset * 2;
                      end;
    end;

    if nbFirst in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_first', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbPrior in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_prior', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbNext in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_next', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbLast in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_last', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbInsert in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_insert', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbDelete in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_delete', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbEdit in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_edit', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbPost in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_post', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbCancel in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_cancel', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if nbRefresh in VisibleButtons then
    begin
      DrawImage('IW_DT_DBNav_refresh', LLeft, LTop, LDeltaLeft, LDeltaTop);
    end;

    if Align = alNone then
    begin
      case Orientation of
        orHorizontal  : Width := LLeft;
        orVertical    : Height := LTop;
      end;
    end;
  end;
end;
{ TIWPaintHandlerCSNavigator }

procedure TIWPaintHandlerCSNavigator.Paint;
var
  ARect: TRect;
  iLeft, iTop: Integer;
  dLeft, dTop: Integer;
  ABitMap: TBitMap;
  LNavigator: TIWCSCustomNavigator;
{$IFDEF CLR}
  LInstance: HModule;
{$ENDIF}
begin
  // Depending on number of buttons do the painting.
  iLeft := 0;
  iTop := 0;
  dLeft := 0;
  dTop := 0;

  LNavigator := Control as TIWCSCustomNavigator;

  with LNavigator do begin
    case Orientation of
      orHorizontal: begin
          dLeft := ImageWidth + 2;
          dTop := 0;
        end;
      orVertical: begin
          dLeft := 0;
          dTop := ImageHeight + 2;
        end;
    end;

    if nbFirst in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      DrawArrow(Rect(ARect.Left + 3, ARect.Top + 3, ARect.Right - 3, ARect.Bottom - 4), adLeft);
      ControlCanvas.MoveTo(ARect.Left + 5, ARect.Top + 5);
      ControlCanvas.LineTo(ARect.Left + 5, ARect.Bottom - 5);
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbPrior in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      DrawArrow(Rect(ARect.Left + 3, ARect.Top + 3, ARect.Right - 3, ARect.Bottom - 4), adLeft);
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbNext in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      DrawArrow(Rect(ARect.Left + 3, ARect.Top + 3, ARect.Right - 3, ARect.Bottom - 4), adRight);
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbLast in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      DrawArrow(Rect(ARect.Left + 3, ARect.Top + 3, ARect.Right - 3, ARect.Bottom - 4), adRight);
      ControlCanvas.MoveTo(ARect.Right - 5, ARect.Top + 5);
      ControlCanvas.LineTo(ARect.Right - 5, ARect.Bottom - 5);
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbInsert in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      with ControlCanvas do begin
        Brush.Color := clBlack;
        { TODO : Touch plus sign }
        Rectangle(iLeft + 9, iTop + 6, iLeft + 12, iTop + 16);
        Rectangle(iLeft + 6, iTop + 9, iLeft + 15, iTop + 13);
      end;
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbDelete in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      with ControlCanvas do begin
        Brush.Color := clBlack;
        Rectangle(iLeft + 6, iTop + 9, iLeft + 16, iTop + 13);
      end;
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbEdit in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      DrawArrow(Rect(ARect.Left + 2, ARect.Top + 3, ARect.Right - 3, ARect.Bottom - 2), adUp);
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    { TODO : Do these three pending }
    if nbPost in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      ABitMap := TBitMap.Create; try
        {$IFDEF CLR}
        LInstance := FindInstanceContainingResource('IW_POST', RT_BITMAP);
        ABitMap.LoadFromResourceName(LInstance, 'IW_POST');
        {$ELSE}
        ABitMap.LoadFromResourceName(HInstance, 'IW_POST');
        {$ENDIF}
        ControlCanvas.Draw(iLeft + 2, iTop + 3, ABitMap);
      finally ABitMap.Free; end;
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbCancel in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      ABitMap := TBitMap.Create; try
        {$IFDEF CLR}
        LInstance := FindInstanceContainingResource('IW_CANCEL', RT_BITMAP);
        ABitMap.LoadFromResourceName(LInstance, 'IW_CANCEL');
        {$ELSE}
        ABitMap.LoadFromResourceName(HInstance, 'IW_CANCEL');
        {$ENDIF}
        ControlCanvas.Draw(iLeft + 2, iTop + 1, ABitMap);
      finally ABitMap.Free; end;
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if nbRefresh in VisibleButtons then begin
      ARect := DrawButton(Rect(iLeft, iTop, iLeft + ImageWidth, iTop + ImageHeight), iLeft);
      {$IFDEF CLR}
      ABitmap := TBitmap.Create;
      {$ELSE}
      ABitMap := {$IFDEF Linux}QGraphics{$ELSE}Graphics{$ENDIF}.TBitMap.Create; 
      {$ENDIF}
      try
        {$IFDEF CLR}
        LInstance := FindInstanceContainingResource('IW_REFRESH', RT_BITMAP);
        ABitMap.LoadFromResourceName(LInstance, 'IW_REFRESH');
        {$ELSE}
        ABitMap.LoadFromResourceName(HInstance, 'IW_REFRESH');
        {$ENDIF}
        ControlCanvas.Draw(iLeft + 2, iTop + 1, ABitMap);
      finally
        ABitMap.Free;
      end;
      Inc(iLeft, dLeft);
      Inc(iTop, dTop);
    end;
    if Align = alNone then begin
      case Orientation of
        orHorizontal: Width := iLeft;
        orVertical: Height := iTop;
      end;
    end;
  end;
end;
{ TIWPaintHandlerProgressBar }
{$ENDIF}

procedure TIWPaintHandlerProgressBar.Paint;
var
  LPBar: TIWProgressBar;
begin
  LPBar := Control as TIWProgressBar;
  with ControlCanvas, LPBar do begin
    if (toTColor(BGColor) <> clNone) and (toTColor(BGColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(BGColor);
    end else begin
      Brush.Color := clWhite;
    end;

    Brush.Style := bsSolid;
    Pen.Color := clBlack;
    Rectangle(0, 0, Width, Height);
    if Percent > 0 then begin
      Brush.Color := toTColor(WebColor);
      Brush.Style := bsSolid;
      Pen.Color := toTColor(WebColor);
      Rectangle(1, 1, (Width * Percent) div 100, Height - 1);
    end;
  end;
end;

{ TIWPaintHandlerLabel32 }

procedure TIWPaintHandlerLabel32.Paint;
var
  LWidth: Integer;
  LLabel: TIWCustomLabel32;
  LLeft: Integer;
{$IFDEF VSNET}
  L: TIWColor;
{$ENDIF}
begin
  LLabel := Control as TIWCustomLabel32;
  with ControlCanvas do
  begin
{$IFNDEF Linux}
    TextFlags := 0;
{$ENDIF}
    // Transparent. Do NOT set Brush.Color after this, it will reset this to bsSolid.
    {$IFDEF VSNET}
    if LLabel.Parent is TIWBaseHTMLForm then begin
      L := TIWBaseHTMLForm(LLabel.Parent).BGColor;
    end else begin
      if LLabel.Parent is TIWCustomRegion32 then begin
        L := TIWCustomRegion32(LLabel.Parent).WebColor;
      end;
    end;
    if (toTColor(L) <> clNone) and (toTColor(L) <> clWebTransparent) then
    begin
      Brush.Color := ToTColor(L);
    end
    else begin
      Brush.Color := clWhite;
    end;
    Brush.Style := bsSolid;
    FillRect(rect(0, 0, LLabel.Width, LLabel.Height));
    {$ELSE}
    Brush.Style := bsClear;
    {$ENDIF}
    SetCanvasFont(LLabel.WebFont);
    LWidth := TextWidth(LLabel.Caption);
//    LWidth := Trunc(TextWidth(LLabel.Caption) * 1.10); // <- it causes wrong size calc at design. Ivan
    LLeft := 0;
    TextRect(Rect(LLeft, 0, LWidth, TextHeight(LLabel.Caption)), LLeft, 0, LLabel.Caption);
    LLabel.Width := LWidth;
    LLabel.Height := TextHeight(LLabel.Caption);
  end;
end;

{ TIWPaintHandlerButton32 }

procedure TIWPaintHandlerButton32.Paint;
var
  LRect: TRect;
  LButton: TIWCustomButton32;
begin
  LButton := Control as TIWCustomButton32;
  with ControlCanvas do begin
    LRect := DrawButton(Rect(0, 0, LButton.Width - 1, LButton.Height - 1), 1);
    Brush.Style := bsClear;
    {if LButton.Color <> clNone then begin
      Brush.Color := LButton.Color;
    end else begin
      Brush.Color := clWhite;
    end;}
    FillRect(LRect);
    // SetCanvasFont(LButton.Font);
    TextRect(LRect, Max(0, (LRect.Right - LRect.Left - TextWidth(LButton.Caption)) div 2)
      , Max(0, (LRect.Bottom - LRect.Top - TextHeight(LButton.Caption)) div 2), LButton.Caption);
  end;
end;

{ TIWPaintHandlerEdit32 }

procedure TIWPaintHandlerEdit32.Paint;
var
  LEdit: TIWCustomEdit32;
  LLeft: Integer;
begin
  LEdit := Control as TIWCustomEdit32;
  with ControlCanvas do
  begin
    {SetCanvasFont(LEdit.Font);

    if toTColor(LEdit.BGColor) <> clNone then
    begin
      Brush.Color := toTColor(LEdit.BGColor);
    end
    else
    begin
      Brush.Color := clWhite;
    end;}

    Rectangle(Rect(0, 0, LEdit.Width, LEdit.Height));
    Draw3DBox;

    {if toTColor(LEdit.Font.BackColor) <> clNone then
    begin
      Brush.Color := toTColor(LEdit.Font.BackColor);
    end;}

    LLeft := 2;
    {case LEdit.Alignment of
      taLeftJustify: LLeft := 2;
      taCenter: LLeft := (LEdit.Width div 2) - (TextWidth(LEdit.Text) div 2) + 2;
      taRightJustify: LLeft := LEdit.Width - TextWidth(LEdit.Text) - 2;
    end;}
    TextRect(Rect(LLeft, 2, Min(LEdit.Width - 2, LLeft + TextWidth(LEdit.Text)), LEdit.Height - 2), LLeft, 2, LEdit.Text);
  end;

(*  LEdit := Control as TIWCustomEdit32;
  with ControlCanvas do begin

    Draw3DBox;
//    SetCanvasFont(LEdit.Font);
   { if LEdit.BGColor <> clNone then begin
      Brush.Color := LEdit.BGColor;
    end else begin
      Brush.Color := clWhite;
    end; }
    TextRect(Rect(2, 2, LEdit.Width - 2, LEdit.Height - 2), 2, 2, LEdit.Text);
  end;*)
end;

{ TIWPaintHandlerList32 }

procedure TIWPaintHandlerList32.Paint;
var
  i, LHeight: integer;
  s: string;
  LList: TIWList32;
begin
  LList := Control as TIWList32;
  with ControlCanvas do begin
    SetTransparent;
    SetCanvasFont(LList.WebFont);
    if LList.Items.Count > 0 then begin
      LHeight := TextHeight(LList.Items.Strings[0]);
      for i := 0 to LList.Items.Count - 1 do begin
        s := LList.Items.Strings[i];
        if LList.Numbered then begin
          s := IntToStr(i + 1) + ' ' + s;
        end else begin
          //TODO: Change to a real bullet
          s := '* ' + s;
        end;
        TextOut(0, i * LHeight, s);
      end;
    end else begin
      DrawOutline;
      DrawResource(Control.ClassName, (Control.Width - 24) div 2, (Control.Height - 24) div 2);
    end;
  end;
end;

{ TIWPaintHandlerListBox32 }

procedure TIWPaintHandlerListBox32.Paint;
var
  Ln, YPos, Bt: Integer;
  LText: string;
  LListBox: TIWCustomListbox32;
begin
  LListBox := Control as TIWCustomListbox32;
  with ControlCanvas do begin
    Brush.Color := clWhite;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, LListBox.Width, LListBox.Height));

    Draw3DBox;
    Ln := 0;
    YPos := 1;
    while (YPos < LListBox.Height - 2) and (Ln < LListBox.Items.Count) do begin
//      SetCanvasFont(LListBox.Font);
      with LListBox do begin
        if ItemsHaveValues then begin
          LText := Items.Values[Items.Names[Ln]];
        end
        else begin
          LText := Items.Strings[Ln];
        end;
      end;

      if Length(LText) < 1 then begin
        LText := ' ';
      end;
      Bt := YPos + TextHeight(LText);
      if Bt >= LListBox.Height - 2 then begin
        Bt := LListBox.Height - 2;
      end;
      if (not LListBox.MultiSelect and (LListBox.ItemIndex = Ln)) or (LListBox.MultiSelect and LListBox.Selected[ln]) then begin
        Font.Color := clWhite;
        Brush.Color := clBlack;
      end else begin
        // Font.Color := LListBox.Font.Color;
        Brush.Color := clWhite;
      end;
      { TODO : Fix black marker on line }
      TextRect(Rect(4, YPos + 2, LListBox.Width - 5, Bt), 4, YPos + 2, LText);
      // Font.Color := LListBox.Font.Color;
      Brush.Color := clNone;

      Inc(Ln);
      YPos := Bt;
    end;
  end;
end;

{ TIWPaintHandlerComboBox32 }

procedure TIWPaintHandlerComboBox32.Paint;
var
  LRect: TRect;
  LComboBox: TIWCustomComboBox32;
begin
  LComboBox := Control as TIWCustomComboBox32;
  with ControlCanvas, LComboBox do begin
    Draw3DBox;
//    SetCanvasFont(LComboBox.Font);
    Brush.Color := clWhite;
    if (ItemIndex >= 0) and (ItemIndex < Items.Count) then begin
      if LComboBox.ItemsHaveValues then begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Values[Items.Names[ItemIndex]]);
      end
      else begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Strings[ItemIndex]);
      end;
    end else begin
      Rectangle(2, 2, Width - 18, Height - 2);
    end;
  //  FCanvas.MoveTo(Width - 16, Height -1);
  //  FCanvas.LineTo(Width - 16, Height -1);
    LRect := DrawButton(Rect(Width - 17, Height - 18, Width - 2, Height - 2));
    //TODO : Button not EXACTLY the same but will do for now. View under zoom 5:1 to see diff
    DrawArrow(LRect, adDown);
  end;
end;

{ TIWPaintHandlerRadioGroup32 }

procedure TIWPaintHandlerRadioGroup32.Paint;
var
  i: Integer;
  LHeight: Integer;
  LWidth: Integer;
  LLeft: Integer;
  LRadioGroup: TIWCustomRadioGroup32;
  LText: string;
  LTop: Integer;
begin
  LRadioGroup := Control as TIWCustomRadioGroup32;
  if LRadioGroup.Items.Count = 0 then begin
    DrawOutline{$IFDEF VSNET}(clSilver){$ENDIF};
  end else begin
    SetTransparent;
    with ControlCanvas do begin
      SetCanvasFont(LRadioGroup.WebFont);
      LLeft := 0;
      LTop := 0;
      if LRadioGroup.Items.Count > 0 then begin
        LText := LRadioGroup.Items.Strings[0];
        LHeight := Max(TextHeight(LText), 12) + 2;
        LWidth := TextWidth(LText) + 18;
        for i := 0 to LRadioGroup.Items.Count - 1 do begin
          DrawResource(iif(LRadioGroup.ItemIndex = i, 'RadioButtonChecked', 'RadioButtonUnchecked')
            , LLeft, LTop);
          TextOut(LLeft + 14, LTop, LRadioGroup.Items.Strings[i]);
          if LRadioGroup.Layout = glVertical then begin
            LTop := LTop + LHeight;
          end else begin
            LLeft := LLeft + LWidth;
          end;
        end;
      end;
    end;
  end;
end;

{ TIWPaintHandlerImage32 }

procedure TIWPaintHandlerImage32.Paint;
var
  LImage: TIWCustomImage32;
begin
  LImage := Control as TIWCustomImage32;
  with ControlCanvas, LImage do begin
    // FPicture is nil during initial create at design time for TIWImageFile (inherited Create)
    if LImage.Picture <> nil then begin
      if LImage.Picture.Graphic <> nil then begin
        Draw(0, 0, LImage.Picture.Graphic);
      end else begin
        DrawOutLine(0, 0, Width, Height{$IFDEF VSNET}, clSilver{$ENDIF});
        DrawResource(ClassName, (Width - 24) div 2, (Height - 24) div 2);
      end;
    end;
  end;
end;

{ TIWPaintHandlerLink32 }

procedure TIWPaintHandlerLink32.Paint;
var
  LLink: TIWLinkBase32;
begin
  LLink := Control as TIWLinkBase32;
  with ControlCanvas do begin
    SetCanvasFont(LLink.WebFont);
    Brush.Style := bsClear;
    Font.Style := Font.Style + [{$IFDEF VSNET}TFontStyle.{$ENDIF}fsUnderline];
    TextOut(0, 0, LLink.Caption);
  end;
end;

{ TIWPaintHandlerMemo32 }

procedure TIWPaintHandlerMemo32.Paint;
var
  LMemo: TIWCustomMemo32;
begin
  LMemo := Control as TIWCustomMemo32;
  with ControlCanvas, LMemo do begin
    Brush.Color := clWindow;
    Draw3DBox;
    Rectangle(Rect(2, 2, Width - 16, Height - 2));
//    SetCanvasFont(LMemo.Font);
    DrawTextLines(Rect(3, 2, Width - 15, Height - 1), LMemo.Lines);
    DrawScrollbar(Rect(Width - 16, 1, Width - 1, Height - 1));
  end;
end;

{ TIWPaintHandlerText32 }

procedure TIWPaintHandlerText32.Paint;
var
  LText: TIWCustomText32;
begin
  LText := Control as TIWCustomText32;
  with ControlCanvas do begin
    SetTransparent;
    if LText.Lines.Count = 0 then begin
      DrawOutline{$IFDEF VSNET}(clSilver){$ENDIF};
      DrawResource(Control.ClassName, (Control.Width - 24) div 2, (Control.Height - 24) div 2);
    end else begin
      SetCanvasFont(LText.WebFont);
      DrawTextLines(Rect(1, 1, LText.Width - 2, LText.Height - 2), LText.Lines);
    end;
  end;
end;

{ TIWPaintHandlerRectangle32 }

procedure TIWPaintHandlerRectangle32.Paint;
var
  LRect: TIWCustomRectangle32;
  LTextRect: TRect;
begin
  LRect := Control as TIWCustomRectangle32;
  with ControlCanvas, LRect do
  begin
    Brush.Color := clBlack;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, LRect.Width, LRect.Height));

    if (toTColor(WebFont.Color) = clNone) or (toTColor(WebFont.Color) = clWebTransparent) then
    begin
      WebFont.Color := fromTColor(clBlack);
    end;
    Brush.Style := bsClear;
    SetCanvasFont(WebFont);
    LTextRect := Rect(BorderWidth, BorderWidth, TextWidth(Text), TextHeight(Text));
    case Alignment of
      taRightJustify: begin
          LTextRect.Left := Width - BorderWidth - LTextRect.Right;
        end;
      taCenter: begin
          LTextRect.Left := (Width - BorderWidth - LTextRect.Right) div 2;
        end;
    end;

    case VAlign of
      vaMiddle: LTextRect.Top := (Height - LTextRect.Bottom) div 2;
      vaBottom: LTextRect.Top := Height - BorderWidth - LTextRect.Bottom;
      vaBaseline: LTextRect.Top := LRect.Height - LTextRect.Bottom;
      vaTop: LTextRect.Top := 0 + BorderWidth;
    end;
    TextOut(LTextRect.Left, LTextRect.Top, Text);
  end;
end;

{ TIWPaintHandlerCheckBox32 }

procedure TIWPaintHandlerCheckBox32.Paint;
var
  LCheckBox: TIWCustomCheckBox32;
begin
  LCheckBox := Control as TIWCustomCheckBox32;
  with ControlCanvas do begin
    Draw3DBox(Rect(0, 0, 15, 15), 2, clSilver, [ssBottom, ssRight]);
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Rectangle(2, 2, 14, 14);
    SetCanvasFont(LCheckBox.WebFont);
    Brush.Style := bsClear;
    TextRect(Rect(20, 2, LCheckBox.Width - 1, LCheckBox.Height - 2), 20, 2, LCheckBox.Caption);
    if LCheckBox.Checked then begin
      Pen.Color := clBlack;
      Brush.Color := clBlack;
      Brush.Style := bsSolid;

      Polygon([{$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 9)
        , {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 11),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 7)
        , {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 5),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 9),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7)]);
    end;
  end;
end;

{ TIWPaintHandlerRadioButton }

procedure TIWPaintHandlerRadioButton.Paint;
var
  LRadioButton: TIWRadioButton;
  LTop: integer;
{$IFDEF VSNET}
  L: TIWColor;
{$ENDIF}
begin
  if not (Control is TIWRadioButton) then
  begin
    inherited Paint;
    Exit;
  end;

  LRadioButton := Control as TIWRadioButton;
  with ControlCanvas do
  begin
    Pen.Color := clBlack;
    Brush.Color := clNone;
    Pen.Style := psSolid;
    {$IFDEF VSNET}
    if LRadioButton.Parent is TIWBaseHTMLForm then begin
      L := TIWBaseHTMLForm(LRadioButton.Parent).BGColor;
    end else begin
      if LRadioButton.Parent is TIWCustomRegion then begin
        L := TIWCustomRegion(LRadioButton.Parent).WebColor;
      end;
    end;
    if (toTColor(L) <> clNone) and (toTColor(L) <> clWebTransparent) then
    begin
      Brush.Color := ToTColor(L);
    end
    else begin
      Brush.Color := clWhite;
    end;
    Brush.Style := bsSolid;
    FillRect(rect(0, 0, LRadioButton.Width, LRadioButton.Height));
    {$ELSE}
    Brush.Style := bsClear;
    {$ENDIF}

    SetCanvasFont(LRadioButton.WebFont);

    LTop := (LRadioButton.Height - TextHeight('O')) div 2;

    DrawResource(iif(LRadioButton.Checked, 'RadioButtonChecked', 'RadioButtonUnchecked'), 2, LTop);
    TextOut(16, LTop, LRadioButton.Caption);
  end;
end;

{ TIWPaintHandlerRadioButton32 }

procedure TIWPaintHandlerRadioButton32.Paint;
var
  LRadioButton: TIWRadioButton32;
  LTop: integer;
begin
  if not (Control is TIWRadioButton32) then
  begin
    inherited Paint;
    Exit;
  end;

  LRadioButton := Control as TIWRadioButton32;
  with ControlCanvas do
  begin
    Pen.Color := clBlack;
    Brush.Color := clNone;
    Pen.Style := psSolid;
    Brush.Style := bsClear;

    SetCanvasFont(LRadioButton.WebFont);

    LTop := (LRadioButton.Height - TextHeight('O')) div 2;

    DrawResource(iif(LRadioButton.Checked, 'RadioButtonChecked', 'RadioButtonUnchecked'), 2, LTop);
    TextOut(16, LTop, LRadioButton.Caption);
  end;
end;

{ TIWPaintHandlerFile }

procedure TIWPaintHandlerFile.Paint;
var
  LButtonWidth: integer;
  AFile: TIWFile;
  LRect: TRect;
  LHeight, LTop: integer;

  procedure DoButton(AColor: TIWColor; ACanvas: TCanvas; ARect: TRect; ACaption: string);
  begin
    with ACanvas do
    begin
      ARect := DrawButton(ARect);
      if (toTColor(AColor) = clNone) or (toTColor(AColor) = clWebTransparent) then
      begin
        Brush.Color := clBtnFace
      end
      else
      begin
        Brush.Color := ToTColor(AColor);
      end;

      FillRect(ARect);
{$IFNDEF Linux}
      TextFlags := 0;
{$ENDIF}
      TextRect(ARect,
        Max(ARect.Left, ARect.Left + (ARect.Right - ARect.Left - TextWidth(ACaption)) div 2),
        Max(ARect.Top, ARect.Top + (ARect.Bottom - ARect.Top - TextHeight(ACaption)) div 2),
        ACaption);
    end;
  end;

begin
  if not (Control is TIWFile) then
  begin
    inherited Paint;
    Exit;
  end;

  AFile := Control as TIWFile;
  with AFile, ControlCanvas do
  begin
    LButtonWidth := Min(Width div 4, 75);
    SetCanvasFont(AFile.WebFont);

    LHeight := Min(23, Height - 4);
    LTop := (Height - LHeight) div 2;

    LRect := Rect(Width - LButtonWidth, LTop, Width, LTop + LHeight);
    InflateRect(LRect, -4, 0);
    DoButton(fromTColor(clBtnFace), ControlCanvas, LRect, 'Browse...');

    Draw3DBox(Rect(0, LTop, Width - LButtonWidth, LTop + LHeight));

    Brush.Style := bsSolid;
    if (toTColor(BGColor) <> clNone) and (toTColor(BGColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(BGColor);
    end else begin
      Brush.Color := clWhite;
    end;
    ControlCanvas.FillRect(Rect(2, LTop + 2, Width - LButtonWidth - 2, LTop + LHeight - 2));
  end;
end;

{ TIWPaintHandlerFile32 }

procedure TIWPaintHandlerFile32.Paint;
var
  LButtonWidth: integer;
  AFile: TIWFile32;
  LRect: TRect;
  LHeight, LTop: integer;

  procedure DoButton(AColor: TIWColor; ACanvas: TCanvas; ARect: TRect; ACaption: string);
  begin
    with ACanvas do
    begin
      ARect := DrawButton(ARect);
      if (toTColor(AColor) = clNone) or (toTColor(AColor) = clWebTransparent) then
      begin
        Brush.Color := clBtnFace
      end
      else
      begin
        Brush.Color := ToTColor(AColor);
      end;

      FillRect(ARect);
{$IFNDEF Linux}
      TextFlags := 0;
{$ENDIF}
      TextRect(ARect,
        Max(ARect.Left, ARect.Left + (ARect.Right - ARect.Left - TextWidth(ACaption)) div 2),
        Max(ARect.Top, ARect.Top + (ARect.Bottom - ARect.Top - TextHeight(ACaption)) div 2),
        ACaption);
    end;
  end;

begin
  if not (Control is TIWFile32) then
  begin
    inherited Paint;
    Exit;
  end;

  AFile := Control as TIWFile32;
  with AFile, ControlCanvas do
  begin
    LButtonWidth := Min(Width div 4, 75);
    SetCanvasFont(AFile.WebFont);

    LHeight := Min(23, Height - 4);
    LTop := (Height - LHeight) div 2;

    LRect := Rect(Width - LButtonWidth, LTop, Width, LTop + LHeight);
    InflateRect(LRect, -4, 0);
    DoButton(fromTColor(clBtnFace), ControlCanvas, LRect, 'Browse...');

    Draw3DBox(Rect(0, LTop, Width - LButtonWidth, LTop + LHeight));

    Brush.Style := bsSolid;
    if (toTColor(BGColor) <> clNone) and (toTColor(BGColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(BGColor);
    end else begin
      Brush.Color := clWhite;
    end;
    ControlCanvas.FillRect(Rect(2, LTop + 2, Width - LButtonWidth - 2, LTop + LHeight - 2));
  end;
end;

{ TIWPaintHandlerRegion }

procedure TIWPaintHandlerRegion.Paint;
var
  LRegion: TIWCustomRegion;
  LRect: TRect;
  LWidth: Integer;
  LBorderColor: TColor;
  {$IFDEF VSNET}
  LColor : Color;
  {$ELSE}
  LColor: TColor;
  {$ENDIF}
begin
  LRegion := Control as TIWCustomRegion;

  {$IFDEF CLR}
  LColor := LRegion.Color;
  {$ELSE}
  LColor := LRegion.WebColor;
  {$ENDIF}

  with ControlCanvas do begin
    if (toTColor(LColor) <> clNone) and (toTColor(LColor) <> clWebTransparent) then begin
      Brush.Color := toTColor(LColor);
    end
    else begin
      Brush.Color := clWhite;
    end;
    Brush.Style := bsSolid;
{$IFDEF VSNET}
    LRect := Borland.VCL.Types.Rect(0, 0, LRegion.Width, LRegion.Height);
{$ELSE}
    LRect := LRegion.ClientRect;
{$ENDIF}
    FillRect(LRect);

    if (toTColor(LRegion.BorderOptions.Color) <> clNone) and
      (toTColor(LRegion.BorderOPtions.Color) <> clWebTransparent) then begin
      LBorderColor := toTColor(LRegion.BorderOptions.Color);
    end else begin
      LBorderColor := toTColor(LColor);
    end;

    LWidth := LRegion.BorderOptions.PixelWidth;

    Pen.Width := LWidth;
    Pen.Style := psSolid;
    Pen.Color := LBorderColor;
    LRect := Rect(0, 0, Control.Width, Control.Height);
    InflateRect(LRect, -(LWidth div 2), -(LWidth div 2));
    if Pen.Width > 0 then begin
      case LRegion.BorderOptions.Style of
        // cbsNone: Pen.Style := psClear;
        // cbsHidden: Pen.Style := psClear;
        cbsDotted: begin
            Pen.Style := psDot;
            Rectangle(LRect);
          end;
        cbsDashed: begin
            Pen.Style := psDash;
            Rectangle(LRect);
          end;
        cbsSolid: begin
            Rectangle(LRect);
          end;
        cbsDouble: begin
            Pen.Width := LWidth div 3;
            LRect := Rect(0, 0, Control.Width, Control.Height);
            InflateRect(LRect, -Pen.Width, -Pen.Width);
            Rectangle(LRect);
            LRect := Rect(0, 0, Control.Width, Control.Height);
            InflateRect(LRect, -(LWidth div 3 + 1), -(LWidth div 3 + 1));
            Rectangle(LRect);
          end;
        cbsGroove: begin
            LRect := Rect(0, 0, Control.Width, Control.Height);
            Draw3DBox(LRect, LWidth div 2, LBorderColor, [ssBottom, ssRight]);
            InflateRect(LRect, -(LWidth div 2), -(LWidth div 2));
            Draw3DBox(LRect, LWidth div 2, LBorderColor, [ssTop, ssLeft]);
          end;
        cbsRidge: begin
            LRect := Rect(0, 0, Control.Width, Control.Height);
            Draw3DBox(LRect, LWidth, toTColor(LRegion.BorderOptions.Color));
          end;
        cbsInset: begin
            LRect := Rect(0, 0, Control.Width, Control.Height);
            Draw3DBox(LRect, LWidth, toTColor(LRegion.BorderOptions.Color));
          end;
        cbsOutset: begin
            LRect := Rect(0, 0, Control.Width, Control.Height);
            Draw3DBox(LRect, LWidth, toTColor(LRegion.BorderOptions.Color), [ssBottom, ssRight]);
          end;
      end;
    end;
  end;
end;

{ TIWPaintHandlerRegion32 }

procedure TIWPaintHandlerRegion32.Paint;
Var
  LRegion: TIWCustomRegion32;
  LRect: TRect;
begin
  LRegion := Control as TIWCustomRegion32;
  with ControlCanvas do begin
    Brush.Color := clWhite;
    Brush.Style := bsSolid;
    {$IFDEF VSNET}
    LRect := Borland.VCL.Types.Rect(0, 0, LRegion.Width, LRegion.Height);
    {$ELSE}
    LRect := LRegion.ClientRect;
    {$ENDIF}
    FillRect(LRect);
    LRect := Rect(0, 0, Control.Width, Control.Height);
    Rectangle(LRect);
  end;
end;

{ TIWPaintHandlerLabelWAP }

procedure TIWPaintHandlerLabelWAP.Paint;
var
  LWidth: Integer;
  LLabel: TIWCustomLabelWAP;
  LLeft: Integer;
begin
  LLabel := Control as TIWCustomLabelWAP;
  with ControlCanvas do
  begin
{$IFNDEF Linux}
    TextFlags := 0;
{$ENDIF}
    // Transparent. Do NOT set Brush.Color after this, it will reset this to bsSolid.
    Brush.Style := bsClear;
//    SetCanvasFont(LLabel.Font);
    LWidth := TextWidth(LLabel.Caption);
//    LWidth := Trunc(LWidth * 1.10);// <- it causes wrong size calc at design. Ivan
    LLeft := 0;
    TextRect(Rect(LLeft, 0, LWidth, TextHeight(LLabel.Caption)), LLeft, 0, LLabel.Caption);
    LLabel.Width := LWidth;
    LLabel.Height := TextHeight(LLabel.Caption);
  end;
end;

{ TIWPaintHandlerButtonWAP }

procedure TIWPaintHandlerButtonWAP.Paint;
var
  LRect: TRect;
  LButton: TIWCustomButtonWAP;
begin
  LButton := Control as TIWCustomButtonWAP;
  with ControlCanvas do begin
    LRect := DrawButton(Rect(0, 0, LButton.Width - 1, LButton.Height - 1), 1);
    Brush.Style := bsClear;
    {if LButton.Color <> clNone then begin
      Brush.Color := LButton.Color;
    end else begin
      Brush.Color := clWhite;
    end;}
    FillRect(LRect);
    // SetCanvasFont(LButton.Font);
    TextRect(LRect, Max(0, (LRect.Right - LRect.Left - TextWidth(LButton.Caption)) div 2)
      , Max(0, (LRect.Bottom - LRect.Top - TextHeight(LButton.Caption)) div 2), LButton.Caption);
  end;
end;

{ TIWPaintHandlerEditWAP }

procedure TIWPaintHandlerEditWAP.Paint;
var
  LEdit: TIWCustomEditWAP;
  LLeft: Integer;
begin
  LEdit := Control as TIWCustomEditWAP;
  with ControlCanvas do
  begin

    Rectangle(Rect(0, 0, LEdit.Width, LEdit.Height));
    Draw3DBox;

    LLeft := 2;
    TextRect(Rect(LLeft, 2, Min(LEdit.Width - 2, LLeft + TextWidth(LEdit.Text)), LEdit.Height - 2), LLeft, 2, LEdit.Text);
  end;

end;

{ TIWPaintHandlerCheckBoxWAP }

procedure TIWPaintHandlerCheckBoxWAP.Paint;
var
  LCheckBox: TIWCustomCheckBoxWAP;
begin
  LCheckBox := Control as TIWCustomCheckBoxWAP;
  with ControlCanvas do begin
    Draw3DBox(Rect(0, 0, 15, 15), 2, clSilver, [ssBottom, ssRight]);
    Brush.Style := bsSolid;
    Brush.Color := clWhite;
    Rectangle(2, 2, 14, 14);
//    SetCanvasFont(LCheckBox.Font);
    Brush.Style := bsClear;
    TextRect(Rect(20, 2, LCheckBox.Width - 1, LCheckBox.Height - 2), 20, 2, LCheckBox.Caption);
    if LCheckBox.Checked then begin
      Pen.Color := clBlack;
      Brush.Color := clBlack;
      Brush.Style := bsSolid;

      Polygon([{$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 9)
        , {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 11),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 7)
        , {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(11, 5),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(7, 9),
          {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Point(5, 7)]);
    end;
  end;
end;

{ TIWPaintHandlerRadioButtonWAP }

procedure TIWPaintHandlerRadioButtonWAP.Paint;
var
  LRadioButton: TIWRadioButtonWAP;
  LTop: integer;
begin
  if not (Control is TIWRadioButtonWAP) then
  begin
    inherited Paint;
    Exit;
  end;

  LRadioButton := Control as TIWRadioButtonWAP;
  with ControlCanvas do
  begin
    Pen.Color := clBlack;
    Brush.Color := clNone;
    Pen.Style := psSolid;
    Brush.Style := bsClear;

//    SetCanvasFont(LRadioButton.Font);

    LTop := (LRadioButton.Height - TextHeight('O')) div 2;

    DrawResource(iif(LRadioButton.Checked, 'RadioButtonChecked', 'RadioButtonUnchecked'), 2, LTop);
    TextOut(16, LTop, LRadioButton.Caption);
  end;
end;

{ TIWPaintHandlerListBoxWAP }

procedure TIWPaintHandlerListBoxWAP.Paint;
var
  Ln, YPos, Bt: Integer;
  LText: string;
  LListBox: TIWCustomListboxWAP;
begin
  LListBox := Control as TIWCustomListboxWAP;
  with ControlCanvas do begin
    Brush.Color := clWhite;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, LListBox.Width, LListBox.Height));

    Draw3DBox;
    Ln := 0;
    YPos := 1;
    while (YPos < LListBox.Height - 2) and (Ln < LListBox.Items.Count) do begin
//      SetCanvasFont(LListBox.Font);
      with LListBox do begin
        if ItemsHaveValues then begin
          LText := Items.Values[Items.Names[Ln]];
        end
        else begin
          LText := Items.Strings[Ln];
        end;
      end;

      if Length(LText) < 1 then begin
        LText := ' ';
      end;
      Bt := YPos + TextHeight(LText);
      if Bt >= LListBox.Height - 2 then begin
        Bt := LListBox.Height - 2;
      end;
      if (not LListBox.MultiSelect and (LListBox.ItemIndex = Ln)) or (LListBox.MultiSelect and LListBox.Selected[ln]) then begin
        Font.Color := clWhite;
        Brush.Color := clBlack;
      end else begin
        // Font.Color := LListBox.Font.Color;
        Brush.Color := clWhite;
      end;
      { TODO : Fix black marker on line }
      TextRect(Rect(4, YPos + 2, LListBox.Width - 5, Bt), 4, YPos + 2, LText);
      // Font.Color := LListBox.Font.Color;
      Brush.Color := clNone;

      Inc(Ln);
      YPos := Bt;
    end;
  end;
end;

{ TIWPaintHandlerComboBoxWAP }

procedure TIWPaintHandlerComboBoxWAP.Paint;
var
  LRect: TRect;
  LComboBox: TIWCustomComboBoxWAP;
begin
  LComboBox := Control as TIWCustomComboBoxWAP;
  with ControlCanvas, LComboBox do begin
    Draw3DBox;
//    SetCanvasFont(LComboBox.Font);
    Brush.Color := clWhite;
    if (ItemIndex >= 0) and (ItemIndex < Items.Count) then begin
      if LComboBox.ItemsHaveValues then begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Values[Items.Names[ItemIndex]]);
      end
      else begin
        TextRect(Rect(2, 2, Width - 18, Height - 2), 2, 2, Items.Strings[ItemIndex]);
      end;
    end else begin
      Rectangle(2, 2, Width - 18, Height - 2);
    end;
  //  FCanvas.MoveTo(Width - 16, Height -1);
  //  FCanvas.LineTo(Width - 16, Height -1);
    LRect := DrawButton(Rect(Width - 17, Height - 18, Width - 2, Height - 2));
    //TODO : Button not EXACTLY the same but will do for now. View under zoom 5:1 to see diff
    DrawArrow(LRect, adDown);
  end;
end;

{ TIWPaintHandlerLinkWAP }

procedure TIWPaintHandlerLinkWAP.Paint;
var
  LLink: TIWLinkBaseWAP;
begin
  LLink := Control as TIWLinkBaseWAP;
  with ControlCanvas do begin
//    SetCanvasFont(LLink.Font);
    Brush.Style := bsClear;
    Font.Style := Font.Style + [{$IFDEF VSNET}TFontStyle.{$ENDIF}fsUnderline];
    TextOut(0, 0, LLink.Caption);
  end;
end;

{ TIWPaintHandlerImageWAP }

procedure TIWPaintHandlerImageWAP.Paint;
var
  LImage: TIWCustomImageWAP;
begin
  LImage := Control as TIWCustomImageWAP;
  with ControlCanvas, LImage do begin
    // FPicture is nil during initial create at design time for TIWImageFile (inherited Create)
    if LImage.Picture <> nil then begin
      if LImage.Picture.Graphic <> nil then begin
        Draw(0, 0, LImage.Picture.Graphic);
      end else begin
        DrawOutLine(0, 0, Width, Height{$IFDEF VSNET}, clSilver{$ENDIF});
        DrawResource(ClassName, (Width - 24) div 2, (Height - 24) div 2);
      end;
    end;
  end;
end;

{ TIWPaintHandlerTabControl }

procedure TIWPaintHandlerTabControl.Paint;
const
  LCTabHeight = 20;
var
  LTabControl : TIWTabControl;
  f : integer;
  LRect : TRect;
  LTabTitle : string;
  LLastLeft : integer;
  LWidth : integer;
  LTabOrder : TList;

begin
  LTabControl := Control as TIWTabControl;
  with ControlCanvas, LTabControl do
  begin

    // Fill the main area
    Brush.Style := bsSolid;
    if (toTColor(LTabControl.WebColor) <> clNone) and
       (toTColor(LTabControl.WebColor) <> clWebTransparent) then
    begin
      Brush.Color := toTColor(LTabControl.WebColor);
    end
    else
    begin
      Brush.Color := clWhite;
    end;
    Brush.Style := bsSolid;


    Pen.Width := 1;
    Pen.Style := psSolid;
    Pen.Color := clBlack;

    // Sort by TabOrder
    LTabOrder := TList.Create;
    try
      for f := 0 to Pred(Pages.Count) do
      begin
        LTabOrder.Add(TIWTabPage(Pages[f]))
      end;
      LTabOrder.Sort(TabOrderCompare);

      LLastLeft := 1;
      for f := 0 to Pred(LTabOrder.Count) do
      begin
        LTabTitle := TIWTabPage(LTabOrder[f]).Title;

        LWidth := TextWidth(LTabTitle) + 4;
        LRect := Rect(LLastLeft, 0, LLastLeft + LWidth, LCTabHeight);
        with LRect do
        begin
          MoveTo(LRect.Left, LRect.Bottom);
          LineTo(LRect.Left, LRect.Top);
          LineTo(LRect.Right, LRect.Top);
          LineTo(LRect.Right, LRect.Bottom);
          if LTabControl.ActivePage <> f then
          begin
            LineTo(LRect.Left, LRect.Bottom);
          end;

          TextOut(LRect.Left + 2, LRect.Top + 2, LTabTitle);

          LLastLeft := LLastLeft + LWidth + 3;
        end;
      end;
    finally
      FreeAndNil(LTabOrder);
    end;
  end;
end;

{ TIWPaintHandlerTabPage }

procedure TIWPaintHandlerTabPage.Paint;
var
  LTabControl : TIWTabControl;
  LTabPage : TIWTabPage;
  LLastLeft : integer;
  LWidth : integer;
  f : integer;

begin
  LTabPage := Control as TIWTabPage;
  LTabControl := LTabPage.Parent as TIWTabControl;

  LLastLeft := 1;
  for f := 0 to Pred(LTabControl.Pages.Count) do
  begin
    LWidth := ControlCanvas.TextWidth(TIWTabPage(LTabControl.Pages[f]).Title) + 4;
    if (LTabControl.ActivePage = f) and (LTabControl.Pages[f] = LTabPage) then
    begin
      with ControlCanvas, LTabPage do
      begin
        Pen.Color := clBlack;
        Pen.Style := psSolid;
        MoveTo(LLastLeft, 0);
        LineTo(1, 0);
        LineTo(1, Height - 1);
        LineTo(Width - 1, Height - 1);
        LineTo(Width - 1, 0);
        LineTo(LLastLeft + LWidth - 1, 0);
      end;
      Break;
    end;
    LLastLeft := LLastLeft + LWidth + 3;
  end;
end;

initialization
  IWRegisterPaintHandler('TIWTabControl', TIWPaintHandlerTabControl);
  IWRegisterPaintHandler('TIWTabPage', TIWPaintHandlerTabPage);
  IWRegisterPaintHandler('TIWApplet', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWDynamicChart', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWHTMLDynamicChartLegend', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWFlash', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWHTMLFlash', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWGrid', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWTimer', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWTreeView', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWRadioGroup', TIWPaintHandlerRadioGroup);
  IWRegisterPaintHandler('TIWRectangle', TIWPaintHandlerRectangle);
  IWRegisterPaintHandler('TIWHTMLRectangle', TIWPaintHandlerRectangle);
  // IWRegisterPaintHandler('TIWMenu', TIWPaintHandlerMenu);
  IWRegisterPaintHandler('TIWLabel', TIWPaintHandlerLabel);
  IWRegisterPaintHandler('TIWButton', TIWPaintHandlerButton);
  IWRegisterPaintHandler('TIWEdit', TIWPaintHandlerEdit);
  IWRegisterPaintHandler('TIWTimeEdit', TIWPaintHandlerEdit);
  IWRegisterPaintHandler('TIWMemo', TIWPaintHandlerMemo);
  IWRegisterPaintHandler('TIWLink', TIWPaintHandlerLink);
  IWRegisterPaintHandler('TIWURL', TIWPaintHandlerLink);
  IWRegisterPaintHandler('TIWText', TIWPaintHandlerText);
  IWRegisterPaintHandler('TIWList', TIWPaintHandlerList);
  IWRegisterPaintHandler('TIWHRule', TIWPaintHandlerHRule);
  IWRegisterPaintHandler('TIWImage', TIWPaintHandlerImage);
  IWRegisterPaintHandler('TIWImageFile', TIWPaintHandlerImage);
  IWRegisterPaintHandler('TIWImageButton', TIWPaintHandlerImage);
  IWRegisterPaintHandler('TIWRadioButton', TIWPaintHandlerRadioButton);
  IWRegisterPaintHandler('TIWFile', TIWPaintHandlerFile);
  IWRegisterPaintHandler('TIWComboBox', TIWPaintHandlerComboBox);
  IWRegisterPaintHandler('TIWListBox', TIWPaintHandlerListBox);
  IWRegisterPaintHandler('TIWCheckBox', TIWPaintHandlerCheckBox);
  IWRegisterPaintHandler('TIWProgressBar', TIWPaintHandlerProgressBar);
  IWRegisterPaintHandler('TIWCSLabel', TIWPaintHandlerLabel);

{$IFNDEF VSNET}
  IWRegisterPaintHandler('TIWDBFile', TIWPaintHandlerFile);
  IWRegisterPaintHandler('TIWDBGrid', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWDBEdit', TIWPaintHandlerEdit);
  IWRegisterPaintHandler('TIWDBLabel', TIWPaintHandlerLabel);
  IWRegisterPaintHandler('TIWDBCheckBox', TIWPaintHandlerCheckBox);
  IWRegisterPaintHandler('TIWDBComboBox', TIWPaintHandlerComboBox);
  IWRegisterPaintHandler('TIWDBLookupComboBox', TIWPaintHandlerComboBox);
  IWRegisterPaintHandler('TIWDBListBox', TIWPaintHandlerListBox);
  IWRegisterPaintHandler('TIWDBLookupListBox', TIWPaintHandlerListBox);
  IWRegisterPaintHandler('TIWDBText', TIWPaintHandlerText);
  IWRegisterPaintHandler('TIWDBMemo', TIWPaintHandlerMemo);
  IWRegisterPaintHandler('TIWDBImage', TIWPaintHandlerImage);
  IWRegisterPaintHandler('TIWDBImage', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWDBNavigator', TIWPaintHandlerDBNavigator);
  IWRegisterPaintHandler('TIWDBEdit32', TIWPaintHandlerEdit32);
  IWRegisterPaintHandler('TIWDBComboBox32', TIWPaintHandlerComboBox32);
  IWRegisterPaintHandler('TIWDBCheckBox32', TIWPaintHandlerCheckBox32);
  IWRegisterPaintHandler('TIWDBLabel32', TIWPaintHandlerLabel32);
  IWRegisterPaintHandler('TIWDBListBox32', TIWPaintHandlerListBox32);
  IWRegisterPaintHandler('TIWDBLookupComboBox32', TIWPaintHandlerComboBox32);
  IWRegisterPaintHandler('TIWDBLookupListBox32', TIWPaintHandlerListBox32);
  IWRegisterPaintHandler('TIWDBMemo32', TIWPaintHandlerMemo32);
  IWRegisterPaintHandler('TIWDBText32', TIWPaintHandlerText32);
  IWRegisterPaintHandler('TIWDBImage32', TIWPaintHandlerImage32);
  IWRegisterPaintHandler('TIWDBRadioGroup32', TIWPaintHandlerRadioGroup32);
  IWRegisterPaintHandler('TIWDBLabelWAP', TIWPaintHandlerLabelWAP);
  IWRegisterPaintHandler('TIWDBEditWAP', TIWPaintHandlerEditWAP);
  IWRegisterPaintHandler('TIWDBCheckBoxWAP', TIWPaintHandlerCheckBoxWAP);
  IWRegisterPaintHandler('TIWDBComboBoxWAP', TIWPAintHandlerComboBoxWAP);
  IWRegisterPaintHandler('TIWDBListBoxWAP', TIWPaintHandlerListBoxWAP);
  IWRegisterPaintHandler('TIWDBLookupComboBoxWAP', TIWPaintHandlerComboBoxWAP);
  IWRegisterPaintHandler('TIWDBLookupListBoxWAP', TIWPaintHandlerListBoxWAP);
  IWRegisterPaintHandler('TIWDBImageWAP', TIWPaintHandlerImageWAP);
  IWRegisterPaintHandler('TIWCSNavigator', TIWPaintHandlerCSNavigator);
  IWRegisterPaintHandler('TIWHTMLDynamicChart', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWDynamicChartLegend', TIWPaintHandlerComponent);  
{$ENDIF}

  // HTML 3.2
  IWRegisterPaintHandler('TIWLabel32', TIWPaintHandlerLabel32);
  IWRegisterPaintHandler('TIWButton32', TIWPaintHandlerButton32);
  IWRegisterPaintHandler('TIWEdit32', TIWPaintHandlerEdit32);
  IWRegisterPaintHandler('TIWHRule32', TIWPaintHandlerHRule);
  IWRegisterPaintHandler('TIWList32', TIWPaintHandlerList32);
  IWRegisterPaintHandler('TIWComboBox32', TIWPaintHandlerComboBox32);
  IWRegisterPaintHandler('TIWListBox32', TIWPaintHandlerListBox32);
  IWRegisterPaintHandler('TIWImage32', TIWPaintHandlerImage32);
  IWRegisterPaintHandler('TIWImageFile32', TIWPaintHandlerImage32);
{$IFNDEF VSNET}IWRegisterPaintHandler('TIWRadioGroup32', TIWPaintHandlerRadioGroup32); {$ENDIF}
  IWRegisterPaintHandler('TIWGrid32', TIWPaintHandlerComponent);
  IWRegisterPaintHandler('TIWURL32', TIWPaintHandlerLink32);
  IWRegisterPaintHandler('TIWMemo32', TIWPaintHandlerMemo32);
  IWRegisterPaintHandler('TIWText32', TIWPaintHandlerText32);
  IWRegisterPaintHandler('TIWRadioButton32', TIWPaintHandlerRadioButton32);
  IWRegisterPaintHandler('TIWRectangle32', TIWPaintHandlerRectangle32);
  IWRegisterPaintHandler('TIWCheckBox32', TIWPaintHandlerCheckBox32);
  IWRegisterPaintHandler('TIWHyperLink32', TIWPaintHandlerLink32);
	IWRegisterPaintHandler('TIWFile32', TIWPaintHandlerFile32);
  IWRegisterPaintHandler('TIWRegion', TIWPaintHandlerRegion);
  IWRegisterPaintHandler('TIWRegion32', TIWPaintHandlerRegion32);

{$IFDEF VSNET}
  IWRegisterPaintHandler('TIWUserControl', TIWPaintHandlerRegion);
  IWRegisterPaintHandler('TIWUserControl32', TIWPaintHandlerRegion32);
{$ENDIF}

  IWRegisterPaintHandler('TIWLabelWAP', TIWPaintHandlerLabelWAP);
  IWRegisterPaintHandler('TIWEditWAP', TIWPaintHandlerEditWAP);
  IWRegisterPaintHandler('TIWCheckBoxWAP', TIWPaintHandlerCheckBoxWAP);
  IWRegisterPaintHandler('TIWRadioButtonWAP', TIWPaintHandlerRadioButtonWAP);
  IWRegisterPaintHandler('TIWButtonWAP', TIWPaintHandlerButtonWAP);
  IWRegisterPaintHandler('TIWListBoxWAP', TIWPaintHandlerListBoxWAP);
  IWRegisterPaintHandler('TIWComboBoxWAP', TIWPaintHandlerComboBoxWAP);
  IWRegisterPaintHandler('TIWHyperLinkWAP', TIWPaintHandlerLinkWAP);
  IWRegisterPaintHandler('TIWLinkWAP', TIWPaintHandlerLinkWAP);
  IWRegisterPaintHandler('TIWURLWAP', TIWPaintHandlerLinkWAP);
  IWRegisterPaintHandler('TIWImageWAP', TIWPaintHandlerImageWAP);
  IWRegisterPaintHandler('TIWImageFileWAP', TIWPaintHandlerImageWAP);
//  IWRegisterPaintHandler('TIWRadioButtonWAP', TIWPaintHandlerRadioButtonWAP);
end.

